// base plugin
CBasePlugin = OOP_Derive( CHook );

/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:__ctor( )

end


/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnAccess( pl, flag )

	//
	// return true/false/nil to determine if they have access or not.
	//	nil = use default access
	//	true = grant access
	//	false = deny access
	//

end

/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnLoaded( pl, filename )

	//
	// return false to not load this vmf
	//

end


/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnSpawned( pl, filename, vmf )

	//
	// return false to not spawn this vmf.
	//

end


/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnMetaDataParse( vmf, data )

	//
	// allows you to modify metadata before it's sent off to the client
	//

end


/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnCheckSpawnSetting( pl, vmf, filename, key )

	// return some value to override the default spawn setting.
	// example:
	//	key is "absolute"
	//	return "1"
	//
	//	Returning "1" will force absolute spawning on every vmf!
	return;

end



/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnEntityPreCreate( vmf, entity )

	//
	// return false to not create this entity.
	//

end



/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnEntityConnection( vmf, entity, connection )

	//
	// return false to not create this connection.
	//

end



/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnEntityKeyValue( vmf, vmf_entity, entity, key, value )

	//
	// return false to not apply this keyvalue.
	//

end



/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnEntityCreated( vmf, entity, entity_table )

	//
	// do something after the entity was created.
	// this entity still hasn't been spawned,
	// or activated yet.
	//

end



/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnEntityActivated( vmf, entity, entity_table )

	//
	// The entity has finally been spawned.
	//

end




/*---------------------------------------------------------

----------------------------------------------------------*/
function CBasePlugin:OnEntityPreCreate( pl, vmf, entity )

	//
	// return false to not create this entity.
	//

end




// Plugin manager.
CPluginManager = OOP_Derive();


/*---------------------------------------------------------

----------------------------------------------------------*/
function CPluginManager:__ctor( )

	// plugins
	self.Plugins = {};

end


/*---------------------------------------------------------

----------------------------------------------------------*/
function CPluginManager:__call( func, ... )

	//
	local ret;
	
	// for each plugin call func, test return value, output final result.
	local name, plugin;
	for name, plugin in pairs( self.Plugins ) do
	
		// method exists?
		if( plugin[ func ] ) then
		
			// call method
			local _ret = plugin[ func ]( plugin, unpack( arg ) );
			if( _ret != nil ) then
			
				ret = _ret;
				break;
			
			end
		
		end
	
	end

	//
	return ret;
	
end


/*---------------------------------------------------------

----------------------------------------------------------*/
function CPluginManager:Register( name, plugin )

	self.Plugins[ name ] = plugin;
	
	Msg( "Registering plugin '" .. name .. "'\n" );

end




//
VMFSuite.PluginSystem = CPluginManager:create();



// load server plugins
if( SERVER ) then

	/*---------------------------------------------------------
		SERVER
	----------------------------------------------------------*/
	local server_plugins = file.FindInLua( "vmf-suite/plugins/server/*.lua" );
	local key, filename;
	for key, filename in pairs( server_plugins ) do
	
		// Load
		include( "vmf-suite/plugins/server/" .. filename );
	
	end

end

/*---------------------------------------------------------
	CLIENT
----------------------------------------------------------*/
local client_plugins = file.FindInLua( "vmf-suite/plugins/client/*.lua" );
local key, filename;
for key, filename in pairs( client_plugins ) do

	// Load ( CLIENT )
	if( CLIENT ) then
	
		include( "vmf-suite/plugins/client/" .. filename );
		
	// Send ( SERVER )
	elseif( SERVER ) then
	
		AddCSLuaFile( "vmf-suite/plugins/client/" .. filename );
	
	end

end
	

/*---------------------------------------------------------
	SHARED
----------------------------------------------------------*/
local shared_plugins = file.FindInLua( "vmf-suite/plugins/shared/*.lua" );
local key, filename;
for key, filename in pairs( shared_plugins ) do

	// Load
	include( "vmf-suite/plugins/shared/" .. filename );
	
	// Send
	if( SERVER ) then
	
		AddCSLuaFile( "vmf-suite/plugins/shared/" .. filename );
	
	end

end
